const router = require("express").Router();
const Response = require("../models/Response");

// submit response
router.post("/", async (req, res) => {
    try {
        const res = await Response.create(req.body);
        res.status(201).json(res);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
})

// Get all responses (optionally filtered by formId)
router.get("/", async (req, res) => {
    try {
        const query = {};
        if (req.query.formId) {
            query.formId = req.query.formId;
        }
        const responses = await Response.find(query);
        res.status(200).json(responses);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
})

// Get single response
router.get("/:id", async (req, res) => {
    try {
        const response = await Response.findById(req.params.id);
        res.status(200).json(response);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
})

module.exports = router;